<?php
// Include the database configuration file
require '../config.php';

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id = intval($_POST['id']); // Get the ID of the record to update
    $title_en = $_POST['title_en'];
    $title_bn = $_POST['title_bn'];
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $start_time = $_POST['start_time'];
    $end_time = $_POST['end_time'];
    $description_en = $_POST['description_en'];
    $description_bn = $_POST['description_bn'];
    $location = $_POST['location'];

    // File upload handling
    $target_dir = "../upload-img/";
    $image_name = basename($_FILES["img"]["name"]); // Get only the image name
    $target_file = $target_dir . $image_name;
    $image_file_type = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    $upload_ok = true;
    $img_query = "";

    // Check if a new file is uploaded
    if (!empty($_FILES["img"]["name"])) {
        if (!in_array($image_file_type, ["jpg", "jpeg", "png"])) {
            $upload_ok = false;
            echo "Only JPG, JPEG, and PNG files are allowed.";
            exit();
        }

        if ($_FILES["img"]["size"] > 2097152) {
            $upload_ok = false;
            echo "Image size should not exceed 2MB.";
            exit();
        }

        if ($upload_ok && move_uploaded_file($_FILES["img"]["tmp_name"], $target_file)) {
            $img_query = ", img = '$image_name'"; // Store only the image name
        } else {
            echo "Error uploading the image.";
            exit();
        }
    }

    // Update the database record
    $sql = "UPDATE chandpur_events 
            SET title_en = '$title_en', 
                title_bn = '$title_bn', 
                start_date = '$start_date',
                 end_date = '$end_date',
                 start_time = '$start_time',
                 end_time = '$end_time',
                description_en = '$description_en', 
                description_bn = '$description_bn', 
                location = '$location'
                $img_query 
            WHERE id = $id";

    if ($conn->query($sql) === TRUE) {
        // Redirect to the news list after successful update
        header("Location: events_list.php");
        exit();
    } else {
        echo "Error updating record: " . $conn->error;
    }
} else {
    echo "Invalid request.";
}
?>
