<?php
// Include the database configuration file
require_once '../config.php';

// Start the session
session_start();

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the submitted email and password
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Validate input fields
    if (empty($email) || empty($password)) {
        echo "Email and Password are required!";
        exit;
    }

    // Prepare and execute the SQL query to fetch the user
    $stmt = $conn->prepare("SELECT id, first_name, email, password FROM chandpur_users WHERE email = ?");
    if (!$stmt) {
        die("Database error: " . $conn->error);
    }

    // Bind the email parameter to the SQL query
    $stmt->bind_param("s", $email);
    $stmt->execute();

    // Bind the result variables
    $stmt->bind_result($id, $first_name, $email_db, $hashed_password);

    // Fetch the results
    if ($stmt->fetch()) {
        // Verify the password using password_verify()
        if (password_verify($password, $hashed_password)) {
            // Set session variables
            $_SESSION['user_id'] = $id;
            $_SESSION['user_name'] = $first_name;
            $_SESSION['user_email'] = $email_db;

            // Redirect to the index page
            header("Location: index.php");
            exit;
        } else {
            echo "Invalid password!";
        }
    } else {
        echo "No user found with this email!";
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();
} else {
    echo "Invalid request!";
}
?>
