<?php include 'header.php'?>
<?php
// SQL query to fetch the admissions data, ordered by id in descending order
$sql = "SELECT * FROM chandpur_admission ORDER BY id DESC"; // Ordering by 'id' in descending order
$result = $conn->query($sql);
$admissions = []; 
// Check if there are results
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $admissions[] = $row; // Append each row to the admissions array
    }
} else {
    $admissions = [];
}

$conn->close();
?>

<!-- DataTables -->
<link rel="stylesheet" href="bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
<?php include 'sidebar.php'?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
       Admission Request List
        <small>Admission Request List</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Admission Request List</a></li>
        <li class="active">Data Admission Request List</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">


          <div class="box">
            <div class="box-header">
              <h3 class="box-title">Data Admission Request List</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>SL</th>

                  <th>Name & Details</th>
                  <th>Admission Request Date Time</th>

                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
                <?php if (!empty($admissions)): ?>
                    <?php foreach ($admissions as $index => $row): ?>
                <tr>
                    <td><?php echo $index + 1; ?></td>
                    <td>
                        <div class="d-flex" style="display:flex;justify-content:flex-start; column-gap:10px">
                        <img src="../<?php echo $row['img'] ?>" style="width:50px; height:50px; border-radius:50%; object-position:center; object-fit:cover;">
                        <div class="user_details ml-2">
                           <strong><?php echo $row['first_name'] ?> <?php echo $row['last_name'] ?></strong><br>
                           <span><b>Father's Name</b> <?php echo $row['father_name'] ?></span><br>
                           <span><b>Mother's Name</b> <?php echo $row['mother_name'] ?></span><br>
                           <span><b>Class</b> <?php echo $row['admission_class'] ?></span><br>
                           <span><b>Gender</b> <?php echo $row['gender'] ?></span><br>
                           <span><b><i class="fa fa-phone"></i></b> <?php echo $row['mobile_no'] ?></span><br>
                           <span><b><i class="fa fa-whatsapp"></i></b> <?php echo $row['whatsapp_no'] ?></span><br>
                        </div>
                        </div>
                    </td>
                    <td>
    <?php
// Convert the 'created_at' value to a DateTime object
$createdAt = new DateTime($row['created_at']);

// Format it as dd/mm/yyyy and time in AM/PM format
echo $createdAt->format('d/m/Y h:i A');
?>
</td>
                    <td>
                       <button class="btn btn-sm btn-warning" data-toggle="modal" data-target="#<?php echo $row['id'] ?>Modal"><i class="fa fa-eye"></i></button>
                       <a class="btn btn-sm btn-danger" 
                       href="delete_request.php?id=<?php echo $row['id']; ?>"
                        onclick="return confirm('Are you sure you want to delete this item?');"
                       >
                       <i class="fa fa-trash"></i>
                       
                      </a>
                      
                    </td>


        <div class="modal fade" id="<?php echo $row['id'] ?>Modal">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php echo $row['first_name'] ?> <?php echo $row['last_name'] ?></h4>
              </div>
              <div class="modal-body">
              <div class="divedder-span" style="display:flex; justify-content:flex-start; column-gap:10px; flex-wrap:wrap; ">
                                        <span><b>Father's AADHAR No:</b> <?php echo $row['father_aadhar_no'] ?></span>
                                        <span><b>Mother's AADHAR No:</b> <?php echo $row['mother_aadhar_no'] ?></span>
                                        <span><b>Guardian's Name:</b> <?php echo $row['gurdian_name'] ?></span>
                                        <span><b>Guardian's AADHAR No:</b> <?php echo $row['gurdian_aadhar_no'] ?></span>
                                        <span><b>Guardian's Relation:</b> <?php echo $row['gurdian_relation'] ?></span>
                                        <span><b>Occupation:</b> <?php echo $row['occupation'] ?></span>
                                        <span><b>Yearly Income:</b> <?php echo $row['yearly_income'] ?></span>
                                        <span><b>Ration Card No:</b> <?php echo $row['ration_card_no'] ?></span>
                                        <span><b>Ration Status:</b> <?php echo $row['user_ration_status'] ?></span>
                                        <span><b>Student AADHAR No:</b> <?php echo $row['student_aadhar_no'] ?></span>
                                        <span><b>Admission Class:</b> <?php echo $row['admission_class'] ?></span>
                                        <span><b>Village:</b> <?php echo $row['vill'] ?></span>
                                        <span><b>Post:</b> <?php echo $row['post'] ?></span>
                                        <span><b>Panchayat:</b> <?php echo $row['panchayat'] ?></span>
                                        <span><b>Block:</b> <?php echo $row['block'] ?></span>
                                        <span><b>Police Station:</b> <?php echo $row['ps'] ?></span>
                                        <span><b>District:</b> <?php echo $row['dist'] ?></span>
                                        <span><b>Pin Code:</b> <?php echo $row['pin'] ?></span>
                                        <span><b>Permanent Village:</b> <?php echo $row['permanent_vill'] ?></span>
                                        <span><b>Permanent Post:</b> <?php echo $row['permanennt_po'] ?></span>
                                        <span><b>Permanent Panchayat:</b> <?php echo $row['permanennt_po'] ?></span>
                                        <span><b>Permanent Block:</b> <?php echo $row['permanennt_po'] ?></span>
                                        <span><b>Permanent Police Station:</b> <?php echo $row['permanennt_po'] ?></span>
                                        <span><b>Permanent District:</b> <?php echo $row['permanennt_po'] ?></span>
                                        <span><b>Permanent Pin Code:</b> <?php echo $row['permanennt_po'] ?></span>
                                        <span><b>Mobile No:</b> <?php echo $row['mobile_no'] ?></span>
                                        <span><b>WhatsApp No:</b> <?php echo $row['whatsapp_no'] ?></span>
                                        <span><b>Date of Birth:</b> <?php echo $row['dob'] ?></span>
                                        <span><b>Gender:</b> <?php echo $row['gender'] ?></span>
                                        <span><b>Nationality:</b> <?php echo $row['nationality'] ?></span>
                                        <span><b>Religion:</b> <?php echo $row['religion'] ?></span>
                                        <span><b>Caste:</b> <?php echo $row['caste'] ?></span>
                                        <span><b>Blood Group:</b> <?php echo $row['blooad_group'] ?></span>
                                        <span><b>Physically Challenged:</b>   <?php echo $row['physicallyChallenged'] == 1 ? 'Yes ' : 'No'; ?></span>
                                        <span><b>Percent:</b> <?php echo $row['percent'] ?>%</span>
                                    </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /.modal -->

                </tr>
                <?php endforeach;?>
        <?php else: ?>
            <tr>
                <td colspan="4">No admission requests found.</td>
            </tr>
        <?php endif;?>

                </tfoot>
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
   <?php include 'footer.php'?>
   <!-- DataTables -->
<script src="bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
   <script>
  $(function () {
    $('#example1').DataTable()
    $('#example2').DataTable({
      'paging'      : true,
      'lengthChange': true,
      'searching'   : true,
      'ordering'    : true,
      'info'        : true,
      'autoWidth'   : true
    })
  })
</script>