<?php include 'header.php'?>
<?php
// SQL query to fetch the admissions data, ordered by id in descending order
$sql = "SELECT * FROM chandpur_events ORDER BY id DESC"; // Ordering by 'id' in descending order
$result = $conn->query($sql);
$admissions = []; 
// Check if there are results
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $admissions[] = $row; // Append each row to the admissions array
    }
} else {
    $admissions = [];
}

$conn->close();
?>

<!-- DataTables -->
<link rel="stylesheet" href="bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
<?php include 'sidebar.php'?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
      Events  List
        <small>Events  List</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Events List</a></li>
        <li class="active">Data Events List</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">


          <div class="box">
            <div class="box-header">
              <h3 class="box-title">Data Events List</h3>
              <a href="add_events.php" class="pull-right btn btn-sm btn-info">Add New <i class="fa  fa-plus"></i></a>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>SL</th>
                  <th>Img</th>
                  <th>Title</th>
                  <th>Date Time</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
                <?php if (!empty($admissions)): ?>
                    <?php foreach ($admissions as $index => $row): ?>
                <tr>
                    <td><?php echo $index + 1; ?></td>
                    <td>

                        <img src="../upload-img/<?php echo $row['img'] ?>" style="width:100px; height:100px;  object-position:center; object-fit:cover;">

                    </td>
                    <td>

                        <?php echo $row['title_en'] ?>

                    </td>
                    <td>

                    <span>Start Date & Time : <b><?php
$date = new DateTime($row['start_date']);
echo $date->format('d'); // Outputs: 16
?> / <?php
$date = new DateTime($row['start_date']);
echo $date->format('M'); // Outputs: 16
?> / <?php
$date = new DateTime($row['start_date']);
echo $date->format('Y'); // Outputs: 16
?> - <?php
$time = new DateTime($row['start_time']);
echo $time->format('h:i A'); // Outputs: 06:30 PM (in 12-hour format)
?></b></span><br>
                    <span>End Date & Time : <b><?php
$date = new DateTime($row['end_date']);
echo $date->format('d'); // Outputs: 16
?>/<?php
$date = new DateTime($row['start_date']);
echo $date->format('M'); // Outputs: 16
?>/<?php
$date = new DateTime($row['start_date']);
echo $date->format('Y'); // Outputs: 16
?> -
  <?php
$time = new DateTime($row['end_time']);
echo $time->format('h:i A'); // Outputs: 06:30 PM (in 12-hour format)
?></b></span><br>
                  
                    </td>
                    <td>
                      <a href="events_edit.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-warning" title="Edit"><i class="fa fa-edit"></i></a>
                      <a href="delete_events.php?id=<?php echo $row['id']; ?>"
   class="btn btn-sm btn-danger"
   title="Delete"
   onclick="return confirm('Are you sure you want to delete this item?');">
   <i class="fa fa-trash"></i>
</a>

                    </td>





        <!-- /.modal -->

                </tr>
                <?php endforeach;?>
        <?php else: ?>
            <tr>
                <td colspan="4">No Events  found.</td>
            </tr>
        <?php endif;?>

                </tfoot>
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
   <?php include 'footer.php'?>
   <!-- DataTables -->
<script src="bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
   <script>
  $(function () {
    $('#example1').DataTable()
    $('#example2').DataTable({
      'paging'      : true,
      'lengthChange': true,
      'searching'   : true,
      'ordering'    : true,
      'info'        : true,
      'autoWidth'   : true
    })
  })
</script>