<?php
// Include the database configuration file
require '../config.php';

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve and sanitize form data
    $title_en = htmlspecialchars($_POST['title_en']);
    $title_bn = htmlspecialchars($_POST['title_bn']);

    // File upload handling
    $target_dir = "../upload-img/";
    $image_name = basename($_FILES["img"]["name"]); // Get only the image name
    $target_file = $target_dir . $image_name;
    $image_file_type = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    $upload_ok = true;

    // Check file type and size
    if (!in_array($image_file_type, ["jpg", "jpeg", "png"])) {
        $upload_ok = false;
        echo "Only JPG, JPEG, and PNG files are allowed.";
    }

    if ($_FILES["img"]["size"] > 2097152) {
        $upload_ok = false;
        echo "Image size should not exceed 2MB.";
    }

    // If the upload is successful, insert data into the database
    if ($upload_ok) {
        if (move_uploaded_file($_FILES["img"]["tmp_name"], $target_file)) {
            // Prepare the SQL statement to avoid SQL injection
            $sql = "INSERT INTO chandpur_photo_gallery (title_en, title_bn, img) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($sql);

            if ($stmt) {
                // Bind parameters to the SQL query
                $stmt->bind_param("sss", $title_en, $title_bn, $image_name);
                
                // Execute the query
                if ($stmt->execute()) {
                    // Redirect to photo gallery list after successful submission
                    header("Location: photo_gallery_list.php");
                    exit();
                } else {
                    echo "Error: " . $stmt->error;
                }
            } else {
                echo "Error preparing query: " . $conn->error;
            }
        } else {
            echo "Error uploading the image.";
        }
    }
}
?>
